my $showsub;
$showsub = sub {
  my ($val, $field, %opt) = @_;
  $field ||= '';
  my $nval;
  if (!defined $val) {
    $nval = '&:y;undef&:n;';
  } elsif (ref $val) {
    if (ref $val eq 'ARRAY') {
      if ($field eq 'extra_descs') {
        $nval = "&:g;(&:n;" . (join '&:y;, &:n;', map {$showsub->($_, 'extra_descs>>desc')} @$val) . "&:g;)&:n;";
      } else {
        $nval = "&:y;[&:n;" . (join '&:y;, &:n;', map {$showsub->($_)} @$val) . "&:y;]&:n;";
      }
    } elsif (ref $val eq 'HASH') {
      if ($field eq 'exits' or $field eq 'has_slot' or $field eq 'affects') {
        $nval = "&:y;{&:n;\n" . (join "&:y;,\n&:n;", map {"&:c;$_&:n: " . $showsub->($val->{$_})} keys %$val) . "&:y;}&:n;";
      } elsif ($field eq 'extra_descs>>desc') {
        $nval = "\n" . $showsub->($val->{keywords}) . " &:y;=>&:n; " . $showsub->($val->{desc}); 
      } else {
        $nval = "&:y;{&:n;" . (join '&:y;, &:n;', map {"&:c;$_&:n: " . $showsub->($val->{$_})} keys %$val) . "&:y;}&:n;";
      }
    } elsif (ref $val eq 'SCALAR' or ref $val eq 'REF') {
      $nval = "&:y;\&:n;" . $showsub->($$val);
    } elsif (ref $val eq 'CODE') {
      $nval = "$val";
    } elsif (ref $val eq 'GLOB') {
      $nval = "&:y;GLOB&:n;";
    } elsif (ref $val eq 'MObjectRef') {
      (my $name = $val->name) =~ s/^(.{14})(.{3}).*/$1.../;
      $nval = "&:y;OBJ{&:n;" . $name . "&:y;#&:n;" . $val->id . "&:y;}&:n;";
    } elsif ($val->isa('MConnection')) {
      $nval = "&:y;CON{&:n;" . $val->ip . ":" . $val->port . "&:y;#&:n;" . $val->id . "&:y;}&:n;";
    } else {
      $nval = "&:y;ref type ".ref($val)."&:n;";
    }
  } elsif ((0 and $val =~ /\n|.{80}/) or $opt{heredoc}) {
    $nval = "<<'%%END%%'\n$val\n%%END%%";
    $nval =~ s/\n\nEND/\nEND/;
  } elsif ($val !~ m#^[-+]?[\w/.]+$#) {
    $nval = $val;
    $nval =~ s/'/\\'/g;
    $nval =~ s/&/&&/g;
    $nval = ($field eq 'ldesc' || $field eq 'idesc' ? "\n" : '') . qq{&:y;'&:n;$nval&:y;'&:n;};
  } else {
    $nval = $val;
  }
  $nval;
};

MObject->Fields (
  'edit_target' => {nostore => 1},
  'edit_delete_confirm' => {},
  'owner' => {},
);

MObject->Commands (
#---------------------------------------------------------------------------------------------------
'mload' => {
  requires => [qw(controller)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Usage: mload <mpMUD module name>");
      return;
    };
    mudlog "(PC) ".$self->nphr." loads module $args";
    MModules->unload_module($args);
    MModules->load_module($args);
  },
  help => <<'EOHELP',
mload <mpMUD module name>

Loads or reloads a mpMUD module.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'munload' => {
  requires => [qw(controller)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Usage: munload <mpMUD module name>");
      return;
    };
    mudlog "(PC) ".$self->nphr." unloads module $args";
    MModules->unload_module($args);
  },
  help => <<'EOHELP',
mload <mpMUD module name>

Unloads a mpMUD module. 
EOHELP
},
#---------------------------------------------------------------------------------------------------
'dbdump' => {
  requires => [qw(controller)],
  code => sub {
    my ($self, $args) = @_;
    
    die "CFAIL:Not implemented yet!"; #FIXME
  },
  help => <<'EOHELP',
Saves a dump of the entire database to a text file named data/dbdump.txt.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'dbsync' => {
  requires => [qw(builder)],
  code => sub {MObjectDB->sync},
  help => <<'EOHELP',
Forces the object cache to be written to disk.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'reuse' => {
  requires => [qw(controller)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Usage: reuse <Perl module>");
      return;
    };
    my $re = $args;
    $re =~ s/::/\\W+/;
    foreach (grep {$_ =~ /$re/} keys %INC) {
      delete $INC{$_};
    }
    mudlog "(PC) @{[$self->name]} re-used $args";
    local $SIG{__WARN__} = sub {$self->send($_[0]) unless $_[0] =~ /[Ss]ubroutine \w+ redefined|Ambiguous use of ({|\w+ =>)/};
    eval "use $args";
    $self->send($@) if $@;
  },
  help => <<'EOHELP',
reuse <Perl module>

Reloads a given Perl module. &:sb;This command should NOT be used unless you are familiar with the operation of Perl and the code of mpMUD.&:n 

Important to note is that this will not cause new imported symbols to be visible to existing packages; it only reloads the code. 

This command should only be used in emergency situations.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'fields' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $field) = @_;
    
    if ($field) {
      $self->send($showsub->(MObject->field_attrs($field)));
    } else {
      $self->send_page($self->connection->format_multicol(sort MObject->fields));
    }
  },
},
#---------------------------------------------------------------------------------------------------

### Index Commands #####################################################################################################

#---------------------------------------------------------------------------------------------------
'ilist' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $key) = @_;
    
    my @items = MIndex->find($key) or die "CFAIL:There are no index entries matching '$key'.";
    $self->send_multicol(map {&{sub{
      if (!ref $_) {
        return "$_: " . MIndex->get($_)->id;
      } elsif (ref $_ eq 'MIndex') {
        return $_->name;
      }
    }}} @items);
  },
},
#---------------------------------------------------------------------------------------------------
'iset' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    
    my ($key, $val) = split /\s+/, $args;
    if ($val !~ /^\d+$/) {
      $val = $self->object_find($val);
    }
    !MIndex->get($key) or die "CFAIL:There is already an index entry '$key'.";
    MIndex->set($key, $val);
    $self->send("Index entry set.");
  },
},
#---------------------------------------------------------------------------------------------------
'iclear' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    
    my ($key, $val) = split /\s+/, $args;
    MIndex->get($key) or die "CFAIL:There is no index entry '$key'.";
    MIndex->set($key);
    $self->send("Index entry removed.");
  },
},
#---------------------------------------------------------------------------------------------------

### Target Editing Commands #####################################################################################################

#---------------------------------------------------------------------------------------------------
'@select' => {
  requires => [qw(builder)],
  basic => 1,
  code => sub {
    my ($self, $args) = @_;
    my $target;
    
    (my $silent) = $args =~ s/\s*\B(-s)\b\s*//;
    if ($args =~ s/^new\s+//) {
      $target = MObject->new();
      MIndex->set($args, $target);
    } else {
      $target = $self->object_find($args, entire_world => 1)->id;
    }
    if (defined $target) {
      PRIVCHECK: {
        $self->priv_controller and last PRIVCHECK;     # Controllers can edit anything
        my $o = $target->owner or last PRIVCHECK;      # No owner, you can edit it
        eval {$o->id} == $self->id and last PRIVCHECK; # You're the owner, you can edit it
        
        # Method call on $target->owner will die if owner no longer exists, so it's eval{}ed
        
        die 'CFAIL:You do not have permission to edit '.$target->nphr.'.';
      }
    
      $self->edit_target($target);
      $self->send("Edit target selected.");
      if ($target =~ /^\d+$/) {
        MObjectDB->get($target)->send("You feel as if something is watching you.");
      }
    }
    $self->do('@view') unless $silent;
  },
  help => <<'EOHELP',
@select [-s] &:g;thing&:n;
@select [-s] &:g;index.entry.name&:n;
@select [-s] new &:g;index.entry.name&:n;

The &:y;@select&:n; command is used to select objects for editing. The argument can be any normal means of referring to an object, or an index entry.

If the first word is "new", a new object is created, and an index entry is made for it. This is useful for creating prototypes.

The -s flag causes &:y;@select&:n; to not invoke &:y;@view&:n; after selecting the target.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@view' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;
    my ($tname, $target);

    (my $norm) = $args =~ s/\s*(-a)\s*//;
    my $full = $args =~ s/^full\b//i;
    if ($args) {
      $target = $self->object_find($args, entire_world => 1);
      $tname = ($target->id ? "#".$target->id : $args);
    } else {
      $target = $self->edit_target_obj;
      $tname = ($target->id ? "#".$target->id : $self->edit_target);
    }
    
    my @lines = ("($tname) " . $target->name . "'s fields:");
    foreach my $key ($target->fields) {
      next if !$full and $key eq 'id';
      push @lines, sprintf "&:fc;%12s&:n;: %s", $key, $showsub->($target->get_val($key), ($norm?'':$key));
    }
    $self->send_multicol(map {split /\n/, $_} @lines);
  },
  help => <<'EOHELP',
@view thing
@view #id
@view index.entry
@view

@view allows you to examine the fields of an object. Without an argument, it displays the currently selected object. With an argument (which is interpreted the same way as by @select), it displays that object, even if you do not have permission to select that object for editing.

@view performs the same function as 'stat' in CircleMUD.

The data structures are displayed in an almost-Perl syntax. Note that if a structure is surrounded in green parentheses, then it is being displayed in a way other than its actual structure. For example, the 'extra_descs' field displays as if it were a hash with array references for keys. To disable all special formatting, which also includes hiding of some internal fields, provide the '-a' option.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@get' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $key) = @_;
    my $obj = $self->edit_target_obj;
    
    (my $here) = $key =~ s/\s*(-h)\s*//;
    my $ob_name = $obj->name;
    $self->send($ob_name . "'s $key: " . $showsub->($obj->get_val($key), $key, heredoc => $here));
  },
  help => <<'EOHELP',
@get [-h] [-a] &:g;<field>&:n;

Displays the value of the named field in the same fashion as @view, following the prototype chain.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@set' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    my $obj = $self->edit_target_obj;
    
    my ($key, $value) = split /\s*=\s*|\s+/, $args, 2;
    
    defined $value or do {
      $self->send("Set a field, sure, but to what?");
      return;
    };
    
    $value =~ s/^(['"])(.*)\1/$2/;
    
    my $fattrs = MObject->field_attrs($key);
    if ($fattrs) {
      if ($fattrs->{noset}) {
        $self->send("That field can't be set.");
        return;
      }
      if ($fattrs->{requires}) {
        foreach my $r (@{$fattrs->{requires}}) {
          next if $self->get_val($r);
          $self->send("You are not allowed to set $key because you don't have the $r flag.");
          return;
        }
      }

      if (ref($fattrs->{default}) eq 'ARRAY') { $value = [split /\s+/, $value]; }
      elsif (ref($fattrs->{default}) eq 'HASH') { $value = {map {$_, 1} split /,/, $value}; }
    } else {
      $key =~ /^_/ and die "CFAIL:You can't set fields starting with underscores."; 
      $self->send("Warning: $key is a non-standard field.");
    }

    my $ob_name = $obj->name;
    eval {
      $obj->set_val($key, $value);
    };
    $@ and do {$self->send($@); return;};
    $self->send($ob_name . "'s $key set to " . $showsub->($obj->get_val($key), $_) . ".");
  },
  help => <<'EOHELP',
@set key value
@set key=value
@set key="value"

@set sets a field in the currently selected object.

Generally, the value is interpreted as a string. However, if the default value for a field is an array, then @set will automatically split the specified value on whitespace, and use that as the new field value.

Also, if the default value for a field is a hash, then @set will split the 

Some fields, like 'connection', 'ispc', and 'saveable', can't be set. Others, like 'affects' and 'has_slot', should not be set by this command, since their values are complex structures.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@clear' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $key) = @_;
    my $obj = $self->edit_target_obj;
    
    my $fattrs = MObject->field_attrs($key);
    if ($fattrs->{noset}) {
      $self->send("That field can't be set.");
      return;
    }
    if ($fattrs->{requires}) {
      foreach my $r (@{$fattrs->{requires}}) {
        next if $self->get_val($r);
        $self->send("You are not allowed to set $key because you don't have the $r flag.");
        return;
      }
    }

    eval {
      $obj->reset_val($key, $self);
    };
    $@ and do {$self->send($@); return;};
    $self->send($obj->name . "'s $key deleted.");
  },
  help => <<'EOHELP',
@clear key

Deletes a field in the currently selected object, causing the value to be inherited from the object's prototype.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'@delete' => {
  requires => [qw(builder)],
  code => sub {
    my ($self) = @_;
    if (my $conf = $self->edit_delete_confirm) {
      if ($conf eq $self->edit_target) {
        my $obj = $self->edit_target_obj;
        $obj->dispose;
        $self->send($conf . " deleted.");
      }
      $self->reset_val('edit_delete_confirm');
    } else {
      my $obj = $self->edit_target_obj; # assert valid target
      $self->edit_delete_confirm($self->edit_target);
      $self->send("Do you really want to delete @{[$self->edit_target]} (@{[$obj->name]})?\n".
                  "Type \@delete again to confirm.");
    }
  },
},
#---------------------------------------------------------------------------------------------------
((eval "use MIME::Base64 ()", $@) ? () : ('@freeze' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    my $obj = $self->edit_target_obj;
    
    $self->send(<<"EOTHING");
Content-Type: application/octet-stream; name="@{[$obj->name]}#@{[$self->edit_target]}.obj"
Content-Transfer-Encoding: base64

@{[MIME::Base64::encode($obj->freeze)]}
EOTHING
  },
})),
#---------------------------------------------------------------------------------------------------
);

MObject->CommandAliases (
  'ilist' => [qw(mlist olist rlist tlist)],
  'iclear' => [qw(idelete)],
  '@view' => [qw(stat)],
);

MObject->Methods (
edit_target_obj => sub {
  my ($self) = @_;
  my $t = $self->edit_target;
  defined $t or do {
    die "CFAIL:No edit target selected.";
  };
  my $obj = MObjectDB->get($t);
  defined $obj or do {
     $self->edit_target(undef);
    die "CFAIL:Edit target no longer exists.";
  };
  $obj;
},
);
